<?php
ob_start();
if(!(is_readable(realpath(dirname(__FILE__)).'/../include/includesroutines.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/../include/includesroutines.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/../include/includesroutines.inc');
}

if(!(is_readable(realpath(dirname(__FILE__)).'/../include/pagination.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/../include/pagination.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/../include/pagination.inc');
}

if(!(is_readable(realpath(dirname(__FILE__)).'/../include/bsservice.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/../include/bsservice.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/../include/bsservice.inc');
}

$pf = ( isset($_REQUEST['pf']) ? $_REQUEST['pf'] : 0);
setCookieForPage("pf", $pf);
$cn = db_connect();
$url = getCurPageURL('service/');
$avlble = array();
$default_date_period = getCookieForPage('date_period',0) ;
$contlngid = $_SESSION['user_idlanguagecontent'];
$lng_shot = db_getLanguageShortByID($cn, $contlngid);
$isGroup = (isset($_COOKIE['indicatorsisgroup']) ?  $_COOKIE['indicatorsisgroup'] : 0);
session_write_close();

if ( getSetting('portal','useRights',0) == 0 || getSetting('page','showpage.indicators',0) != 1 || IsUserLogin() != 1 ){
	ob_end_flush();
	exit;
}

/* функции для формирования и отсыла массива */
/* =================================================== */
function getInputData($datePeriod, $dateValue, $orderColumn, $orderVal = "asc", $pf = 0, $lang = "ru-ru"){
    global $cn;
    global $errmsg; //STU
	global $avlble;
	global $date_period;

	if ($orderColumn=='before'){
		$orderColumn =
			($pf==1)
			?'datefact'
			:'dateplan';
	} //STU 9902

	$call = sendInputCall($cn, $datePeriod, $dateValue, $orderColumn, $orderVal, $pf, $lang);
	if (!$call) {
		?>
			<br/>
			<table>
			<tr><td><img src="img/error.png" border="0">&nbsp;&nbsp;&nbsp;&nbsp;</td><td><div style="display: table-cell; vertical-align: top"><?php getResource("message.bsserviceerror");?></div></td></tr>
			</table>
			<br/>
		<?php
		ob_end_flush();
		exit;
	}
	$xml = simplexml_load_string($call);

	$errmsgxmlpath = $xml->xpath('//pkg/inputvalues/@errmsg'); //STU
	if ($errmsgxmlpath && sizeof($errmsgxmlpath) > 0 ) { // добавлена проверка на наличие объекта
		$errmsg = $errmsgxmlpath[0]; //STU
	}

	$avlblstr = $xml->xpath('//pkg/inputvalues/@available');
	if ( strlen($avlblstr[0]) > 0) {
		$avlble = explode(',',''.$avlblstr[0]);
    sort($avlble);//STU Потому что нет гарантии, что придут упорядоченные
	}
	if (sizeof($avlble) > 0 && ( !isset( $_GET[ "date_period" ] ) || ( !in_array($_GET[ "date_period" ], $avlble ) ) ) ) {
	    $date_period = $avlble[0];
	}

	$elems = $xml->xpath('//value');
	$inputArr = array();

	foreach ($elems as $elem){
		$guid = ''.$elem['oguid'];
		$inputArr[$guid] =   array(
			  "Folder" => $elem['folderfullpath'],
			  "Value"=> $elem['oguid'],
			  "DateFrom"=> $elem['datefrom'],
			  "DateTo"=> $elem['dateto'],
			  "ValueType"=> $elem['type'],
			  "DatePlan"=> $elem['dateplan'],
			  "DateFact"=> $elem['datefact'],
			  "Plan"=> $elem['plan'],
			  "Fact"=> $elem['fact']);
	}
	return $inputArr;
}

/* =================================================== */
/* функции для формирования и отсыла массива */



// settings
if(!is_readable(realpath(dirname(__FILE__)).'/../resources/input/dateperiods.inc')) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/../resources/input/dateperiods.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/../resources/input/dateperiods.inc');
}

$onpage = getSetting('page', 'indicators.pagesize', 10);
$default_order_column = getCookieForPage('order_column','value'); 
$default_order_val = getCookieForPage('order_val','asc');

// functions

function getDateString($date, $date_period, $cn ){
	switch ($date_period) {
	    case 0:
	        echo date_format($date, "d.m.Y");
	        break;
	    case 1:
	        echo date_format($date, "d.m.Y");
	        break;
	    case 2:
			    $week = db_getWeekNumber($cn, date_format($date, "Y-m-d"), getSetting('page', 'indicators.calendarweekrule', 'FirstDay'), getSetting('page', 'indicators.firstdayofweek', 'Monday'));
			    $month = date_format($date, "m");
		    	$year = date_format($date, "Y");
			    echo $week." ".getResourceByLang('field.input.week')." ".db_getYearWithWeek($year, $month, $week);
	        break;
	    case 3:
	    	$month = (int) date('m', strtotime(date_format($date, "Y-m-d")."T00:00:01+0000"));
			$months = ['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'];
			echo getResourceByLang('title.month.'.$months[$month-1])." ".date_format($date, "Y");
    		break;
	    case 4:
	    	$month = (int) date('m', strtotime(date_format($date, "Y-m-d")."T00:00:01+0000"));
			echo ceil($month/3).' '.getResourceByLang('field.input.quarter')." ".date_format($date, "Y");    		
	        break;
	    case 5:
	    	$month = (int) date('m', strtotime(date_format($date, "Y-m-d")."T00:00:01+0000"));
	    	echo ceil($month/6).' '.getResourceByLang('field.input.half-year')." ".date_format($date, "Y");    		
	        break;
	    case 6:
	        echo date_format($date, "Y");
	        break;
	}
}

function isNullOrEmptyString( $var ){
    return ( !isset( $var ) || trim( $var ) === '' );
}

function getAdjacentDatePeriod( $date_period, $date_value, $is_next ) {
	global $date_periods, $date_format_internal;
	$date = date_create( fixDate( $date_value ) );
	$date_interval = $date_periods[ $date_period ][ "date_interval" ];
	date_modify( $date, ( $is_next ? "" : "-" ).$date_interval );
	return date_format( $date, $date_format_internal );
}

function buildSortColumnTitleCustom( $name, $is_active, $date_period, $date_value, $order_column, $order_val, $page ) {
	global $default_order_val;
	$new_order_val = ( $order_val == 'asc' ) ? 'desc' : 'asc';
	$link = ( !$is_active ) ? "" : "<nobr><a href=".buildURL( $date_period, $date_value, $order_column, $new_order_val, $page )." class='input-action btn-sort ".( ( $order_val == 'asc' ) ? 'btn-sort-asc' : 'btn-sort-desc' )."' title='".( ( $order_val == 'asc' ) ? '&uarr;' : '&darr;' )."'>".( ( $order_val == 'asc' ) ? '&uarr;' : '&darr;' )."</a>";
	$link .= "<a href=".buildURL( $date_period, $date_value, $order_column, ( $is_active ?  $new_order_val : $default_order_val ), $page )." class='input-action'>".$name."</a></nobr>";
	return $link;
}

function buildDatePeriodButton( $name, $is_active, $date_period, $date_value, $order_column, $order_val, $page ) {
	global $date_periods;
	global $avlble;
	if ( in_array($date_period, $avlble )) {
		$date = date_create( fixDate( $date_value ) );
		return "<a href='".buildURL( $date_period, date_format( $date, $date_periods[ $date_period ][ "date_format_internal" ] ), $order_column, $order_val, $page )."' class='input-action btn-top btn-top-text ".( $is_active ? "btn-top-active" : "" )."' title='".$name."'><span>".$name."</span></a>";
	} else {
		return "";
	}
}

function buildURL( $date_period, $date_value, $order_column, $order_val, $page ) {
	$url = getCurPageURL('service/');
	$url = urlReplaceParam($url,'date_period', $date_period);
	$url = urlReplaceParam($url,'date_value', $date_value);
	$url = urlReplaceParam($url,'order_column', $order_column);
	$url = urlReplaceParam($url,'order_val', $order_val);
	$url = urlReplaceParam($url,'page', $page);
	return  $url;
}


function fixDate( $date_value ) { //dirty month add - date_create() works incorrect with year-only value
	return substr_count( $date_value, "-" ) == 0 ? $date_value."-01" : $date_value;
}


// url parse and build

$date_period = isset( $_REQUEST[ "date_period" ] ) ? $_REQUEST[ "date_period" ] : $default_date_period;
setCookieForPage("date_period", $date_period);
$date_format = $date_periods[ $date_period ][ "date_format" ];
$date_format_internal = $date_periods[ $date_period ][ "date_format_internal" ];
$default_date_value = date( $date_format_internal );
$date_value = isset( $_REQUEST[ "date_value" ] ) ? $_REQUEST[ "date_value" ] : $default_date_value;
setCookieForPage("date_value", $date_value);
$order_column = isset( $_REQUEST[ "order_column" ] ) ? $_REQUEST[ "order_column" ] : $default_order_column;
$order_val = isset( $_REQUEST[ "order_val" ] ) ? $_REQUEST[ "order_val" ] : $default_order_val;
setCookieForPage("order_column", $order_column);
setCookieForPage("order_val", $order_val);
$page = isset( $_REQUEST[ "page" ] ) ? $_REQUEST[ "page" ] : 1;
$date = date_create( fixDate( $date_value ) );
if (isset ($_REQUEST[ "IsGroup" ])) {
	$isGroup = ($_REQUEST[ "IsGroup" ] == 1 ? 1 : 0);
	setCookieLong('indicatorsisgroup', $isGroup);
}

// getting factors array
$factors_arr = getInputData( $date_period, $date_value, $order_column, $order_val, $pf, $lng_shot );
$factors_values_arr = array_values($factors_arr);
$factors_keys_arr = array_keys($factors_arr);

// paging calculations
$total = count( $factors_arr );
$total = ceil($total/$onpage);
$total = $total == 0 ? 1 : $total;
$page = (($page > $total) ? $total : $page);

$url = buildURL( $date_period, $date_value, $order_column, $order_val, $page );
$usr_arr = GetUserIDs();
$lng_shot_interface = db_getLanguageShortByID($cn, $_SESSION['user_idlanguageinterface'], true);

if ( sizeof($avlble) > 0 ) {
?>

				<div class="box-period">

					<div class="box-period-caption"><?php getResource("title.FrequencyIndicator");?></div>

					<span>
<?php
	if ( !in_array($date_period, $avlble )) {
		 $date_period = $avlble[0];
	}

$lng_shot_interface = db_getLanguageShortByID($cn, $_SESSION['user_idlanguageinterface'], true);
foreach( $date_periods as $key => $val ) {
	echo buildDatePeriodButton( $val[ "name" ][ strtolower($lng_shot_interface) ], ( $date_period == $key ), $key, $date_value, $order_column, $order_val, 1 );
}
?>
					</span>
                    <div class="box-group-caption"><?php getResource("title.Group");?>
	                <span><a href="<?php echo urlReplaceParam($url,'IsGroup', 1); ?>" class="input-action btn-top btn-top-text <?php if ($isGroup == 1) { echo 'btn-top-active'; }?>" title="<?php getResource("button.yes");?>"><span><?php getResource("button.yes");?></span></a><a href="<?php echo urlReplaceParam($url,'IsGroup', 0); ?>" class="input-action btn-top btn-top-text <?php if ($isGroup == 0) { echo 'btn-top-active'; }?>" title="<?php getResource("button.no");?>"><span><?php getResource("button.no");?></span></a></span>
					</div>

		</div>

				<div class="box-period">

					<div class="box-period-caption"><?php getResource("field.input.ActivePeriod");?></div>

					<span>
						<a href="<? echo buildURL( $date_period, getAdjacentDatePeriod( $date_period, $date_value, 0 ), $order_column, $order_val, 1 ) ?>" class="input-action btn-top btn-top-arrow btn-top-left" title="&laquo;"><span>&nbsp;&laquo;&nbsp;</span></a><input class="btn-top btn-top-text btn-top-text-datepicker" id="datepicker" readonly="readonly" value="<? echo getDateString( $date, $date_period, $cn ) ?>" /><a href="<? echo buildURL( $date_period, getAdjacentDatePeriod( $date_period, $date_value, 1 ), $order_column, $order_val, 1 ) ?>" class="input-action btn-top btn-top-arrow btn-top-right" title="&raquo;"><span>&nbsp;&raquo;&nbsp;</span></a>
					</span>

					<div id="calend"></div>
					<input type="hidden" id="js_format" value="<? echo $date_periods[ $date_period ][ "js_format" ] ?>">
					<input type="hidden" id="js_format_internal" value="<? echo $date_periods[ $date_period ][ "js_format_internal" ] ?>">
					<input type="hidden" id="js_start" value="<? echo $date_periods[ $date_period ][ "js_start" ] ?>">
					<input type="hidden" id="js_exit" value="<? echo $date_periods[ $date_period ][ "js_exit" ] ?>">
					<input type="hidden" id="js_day" value="<? echo date_format( $date, "j" ) ?>">
					<input type="hidden" id="js_month" value="<? echo date_format( $date, "n" ) ?>">
					<input type="hidden" id="js_year" value="<? echo date_format( $date, "Y" ) ?>">
				</div>

				<div class="box-period">
					<div class="box-period-caption"><?php getResource("field.input.InputValues");?></div>
					<span>
						<a href="<?php echo urlReplaceParam(urlReplaceParam($url,'date_period', $avlble[0]),'pf', 1); ?>" class="input-action btn-top btn-top-text <?php if ($pf == 1) { echo 'btn-top-active'; }?>" title="<?php getResource("field.input.Plan");?>"><span><?php getResource("field.input.Plan");?></span></a><a href="<?php echo urlReplaceParam(urlReplaceParam($url,'date_period', $avlble[0]),'pf', 0); ?>" class="input-action btn-top btn-top-text <?php if ($pf == 0) { echo 'btn-top-active'; }?>" title="<?php getResource("field.input.Fact");?>"><span><?php getResource("field.input.Fact");?></span></a>
					</span>
				</div>
				<div class="" style="height: 5px;"></div>				

<?php
// table output
if (is_array($factors_arr) && count($factors_arr) > 0 ) {
?>
				<form method="post" action="<? echo $url ?>" id="form-factors">
				<section id="box-buttons" style="margin: 0px 0px 10px 0px;">
					<span style="margin-right: 11px;"><button class="btn-top btn-top-text" title="<?php getResource("button.Save.hint");?>" id="btn-ok" type="submit"><span><i class="btn-top-text-icon btn-top-text-icon-ok"></i><?php getResource("button.Save");?></span></button></span>
					<span><button class="btn-top btn-top-text btn-cancel" title="<?php getResource("button.cancel.hint");?>" id="btn-cancel" type="button"><span><i class="btn-top-text-icon btn-top-text-icon-cancel"></i><?php getResource("button.cancel");?></span></button></span>
				</section>

				<table class="tbldata" cellspacing="0">
					<tr>
						<th class="<? if( $order_column == "value" ) echo "tbldata-cell-sortable" ?> tblinput-cell-name"><? echo buildSortColumnTitleCustom( getResourceByLang('field.input.indicator', $lng_shot_interface), ( $order_column == "value" ? true : false ), $date_period, $date_value, "value", $order_val, $page ) ?></th>
						<th style="max-width:60px; min-width:60px; width:60px;" class="<? if( $order_column == "valuetype" ) echo "tbldata-cell-sortable" ?> tblinput-cell-input"><? echo buildSortColumnTitleCustom( getResourceByLang('field.input.value', $lng_shot_interface), ( $order_column == "valuetype" ? true : false ), $date_period, $date_value, "valuetype", $order_val, $page ) ?></th>
<?php if (isset($_REQUEST['date_period']) && $_REQUEST['date_period']==0 && in_array($_REQUEST['date_period'], $avlble )) { ?>
						<th class="<? if( $order_column == "datefrom" ) echo "tbldata-cell-sortable" ?> tblinput-cell-input"><? echo buildSortColumnTitleCustom( getResourceByLang('field.input.dateFrom', $lng_shot_interface), ( $order_column == "datefrom" ? true : false ), $date_period, $date_value, "datefrom", $order_val, $page ) ?></th>
						<th class="<? if( $order_column == "dateto" ) echo "tbldata-cell-sortable" ?> tblinput-cell-input"><? echo buildSortColumnTitleCustom( getResourceByLang('field.input.dateTo', $lng_shot_interface) , ( $order_column == "dateto" ? true : false ), $date_period, $date_value, "dateto", $order_val, $page ) ?></th>
<?php } ?>

						<th style="max-width:60px; min-width:60px; width:60px;" class="dateBeforeColumnHeader <? if( $order_column == "before" ) echo "tbldata-cell-sortable" ?> tblinput-cell-input"><? echo buildSortColumnTitleCustom( getResourceByLang('field.input.InputBefore', $lng_shot_interface), ( $order_column == "before" ? true : false ), $date_period, $date_value, "before", $order_val, $page ) ?></th>
						<th style="max-width:90px; min-width:90px; width:90px;" class="<? if( $order_column == "plan" ) echo "tbldata-cell-sortable" ?> tblinput-cell-input"><? echo buildSortColumnTitleCustom( getResourceByLang('field.input.Plan', $lng_shot_interface), ( $order_column == "plan" ? true : false ), $date_period, $date_value, "plan", $order_val, $page ) ?></th>
						<th style="max-width:90px; min-width:90px; width:90px;" class="<? if( $order_column == "fact" ) echo "tbldata-cell-sortable" ?> tblinput-cell-input" id="tbldata-cell-fact"><? echo buildSortColumnTitleCustom( getResourceByLang('field.input.Fact', $lng_shot_interface), ( $order_column == "fact" ? true : false ), $date_period, $date_value, "fact", $order_val, $page ) ?></th>
					</tr>
<?php
$tabNumber = 0;
if (!$isGroup) { // представление без группировке по папкам
	for ($i = $onpage*( $page - 1 ); $i < $onpage*$page ; $i++) {
		if( isset( $factors_values_arr[ $i ] ) ) {

?>
					<tr>
						<td><? echo '<a target="_parent" href="'.getCurPageURLWO('/service').'/businessmodel.php?oguid='.$factors_values_arr[ $i ][ "Value" ].'">'.db_getObjectName($cn, $factors_values_arr[ $i ][ "Value" ], $contlngid ).'</a>'; ?> </td>
						<td><? echo $factors_values_arr[ $i ][ "ValueType" ] ?></td>
<?php if (isset($_REQUEST['date_period']) && $_REQUEST['date_period']==0 && in_array($_REQUEST['date_period'], $avlble )) { ?>
						<td><? echo $factors_values_arr[ $i ][ "DateFrom" ] ?></td>
						<td><? echo $factors_values_arr[ $i ][ "DateTo" ] ?></td>
<?php } ?>
<?php if ($pf == 1) {
		$inputValidDate = true;
		if (strlen(trim($factors_values_arr[ $i ][ "DatePlan" ])) > 0) {
			if (validateDateTime($factors_values_arr[ $i ][ "DatePlan" ])) {
				$inputValidDate = strtotime(date('d.m.Y H:i:s')) < strtotime(date('d.m.Y H:i:s', strtotime(trim($factors_values_arr[ $i ][ "DatePlan" ]))));
			} else {
				$inputValidDate = strtotime(date('d.m.Y')) < strtotime( trim($factors_values_arr[ $i ][ "DatePlan" ]));
			}
		}
?>
						<td class="dateBeforeColumn <? if (!$inputValidDate) { echo 'td-error'; } ?>"><? echo $factors_values_arr[ $i ][ "DatePlan" ] ?></td>
					<?php if($inputValidDate) {
						$tabNumber++;
					?>
						<td class="tbldata-td-caninput"><input  <?echo 'tabnumber="'.$tabNumber.'"'?> type="text" autocomplete="off" name="<? echo $factors_keys_arr[ $i ] ?>" value="<? echo $factors_values_arr[ $i ][ "Plan" ] ?>" class="text-tbldata" /></td>
					<?php } else { ?>
						<td class="tbldata-td-caninput"><? echo $factors_values_arr[ $i ][ "Plan" ] ?></td>
					<?php } ?>
						<td><? echo $factors_values_arr[ $i ][ "Fact" ] ?></td>
<?php } else {
		$inputValidDate = true;
		if (strlen(trim($factors_values_arr[ $i ][ "DateFact" ])) > 0) {
			if (validateDateTime($factors_values_arr[ $i ][ "DateFact" ])) {
				$inputValidDate = strtotime(date('d.m.Y H:i:s')) < strtotime(date('d.m.Y H:i:s', strtotime(trim($factors_values_arr[ $i ][ "DateFact" ]))));
			} else {
				$inputValidDate = strtotime(date('d.m.Y')) < strtotime( trim($factors_values_arr[ $i ][ "DateFact" ]));
			}
		}
?>
						<td class="dateBeforeColumn <? if (!$inputValidDate) { echo 'td-error'; } ?>"><? echo $factors_values_arr[ $i ][ "DateFact" ] ?></td>
						<td><? echo $factors_values_arr[ $i ][ "Plan" ] ?></td>
					<?php if($inputValidDate) {
						$tabNumber++;
					?>
						<td class="tbldata-td-caninput"><input <?echo 'tabnumber="'.$tabNumber.'"'?> type="text" autocomplete="off" name="<? echo $factors_keys_arr[ $i ] ?>" value="<? echo $factors_values_arr[ $i ][ "Fact" ] ?>" class="text-tbldata"/></td>
					<?php } else { ?>
						<td class="tbldata-td-caninput"><? echo $factors_values_arr[ $i ][ "Fact" ] ?></td>
					<?php } ?>
<?php } ?>
					</tr>
<?
		}
	}
// представление без группировке по папкам
} else {
// представление c группировкой по папкам
	$order_column_name = (mb_strtolower($order_column) == 'before' ? ($pf == 1 ? 'DatePlan' : 'DateFact' ) : $order_column); // подстановка колонки для ВводДО
	if (($order_column_name) == 'plan' ||  ($order_column_name) == 'fact' ) {
		$order_column_name .= '*1';
	}
	$factors_sort_arr = db_SortIndicatorsByFolder($cn, $contlngid, $factors_values_arr, $order_column_name, $order_val);
	$factors_values_sort_arr = array_values($factors_sort_arr);
	$factors_keys_sort_arr = array_keys($factors_sort_arr);
	$foldername = '';
	for ($i = $onpage*( $page - 1 ); $i < $onpage*$page ; $i++) {
		if (isset( $factors_values_sort_arr[ $i ] ) ) {
		if ($foldername != $factors_values_sort_arr[ $i ][ "Folder" ]){
		$foldername = $factors_values_sort_arr[ $i ][ "Folder" ];
			?>
					<tr>
						<td colspan="7" class="tbldata-td-folder" style="padding-left: 10px !important;  "><b><? echo $factors_values_sort_arr[ $i ][ "Folder" ] ?></b></td>
					</tr>
<?php
		}
?>
					<tr>
						<td><? echo '<a target="_parent" href="'.getCurPageURLWO('/service').'/businessmodel.php?oguid='.$factors_values_sort_arr[ $i ][ "OGuid" ].'">'.$factors_values_sort_arr[ $i ][ "Value" ].'</a>'; ?> </td>
						<td><? echo $factors_values_sort_arr[ $i ][ "ValueType" ] ?></td>
<?php if (isset($_REQUEST['date_period']) && $_REQUEST['date_period']==0 && in_array($_REQUEST['date_period'], $avlble )) { ?>
						<td><? echo $factors_values_sort_arr[ $i ][ "DateFrom" ] ?></td>
						<td><? echo $factors_values_sort_arr[ $i ][ "DateTo" ] ?></td>
<?php } ?>
<?php if ($pf == 1) {
		$inputValidDate = true;
		if (strlen(trim($factors_values_sort_arr[ $i ][ "DatePlan" ])) > 0) {
			$inputValidDate = strtotime(date('d.m.Y')) < strtotime( trim($factors_values_sort_arr[ $i ][ "DatePlan" ]));
			if (validateDateTime($factors_values_arr[ $i ][ "DatePlan" ])) {
				$inputValidDate = strtotime(date('d.m.Y H:i:s')) < strtotime(date('d.m.Y H:i:s', strtotime(trim($factors_values_arr[ $i ][ "DatePlan" ]))));
			} else {
				$inputValidDate = strtotime(date('d.m.Y')) < strtotime( trim($factors_values_arr[ $i ][ "DatePlan" ]));
			}

		}
?>
						<td class="dateBeforeColumn <? if (!$inputValidDate) { echo 'td-error'; } ?>"><? echo $factors_values_sort_arr[ $i ][ "DatePlan" ] ?></td>
					<?php if($inputValidDate) {
						$tabNumber++;
					?>
						<td><input <?echo 'tabnumber="'.$tabNumber.'"'?> type="text" autocomplete="off" name="<? echo $factors_keys_sort_arr[ $i ] ?>" value="<? echo $factors_values_sort_arr[ $i ][ "Plan" ] ?>" class="text-tbldata" /></td>
					<?php } else { ?>
						<td><? echo $factors_values_sort_arr[ $i ][ "Plan" ] ?></td>
					<?php } ?>
						<td><? echo $factors_values_sort_arr[ $i ][ "Fact" ] ?></td>
<?php } else {
		$inputValidDate = true;
		if (strlen(trim($factors_values_sort_arr[ $i ][ "DateFact" ])) > 0) {
			if (validateDateTime($factors_values_arr[ $i ][ "DateFact" ])) {
				$inputValidDate = strtotime(date('d.m.Y H:i:s')) < strtotime(date('d.m.Y H:i:s', strtotime(trim($factors_values_arr[ $i ][ "DateFact" ]))));
			} else {
				$inputValidDate = strtotime(date('d.m.Y')) < strtotime( trim($factors_values_arr[ $i ][ "DateFact" ]));
			}
		}
?>
						<td class="dateBeforeColumn <? if (!$inputValidDate) { echo 'td-error'; } ?>"><? echo $factors_values_sort_arr[ $i ][ "DateFact" ] ?></td>
						<td><? echo $factors_values_sort_arr[ $i ][ "Plan" ] ?></td>
					<?php if($inputValidDate) {
						$tabNumber++;
					?>
						<td><input <?echo 'tabnumber="'.$tabNumber.'"'?> type="text" autocomplete="off" name="<? echo $factors_keys_sort_arr[ $i ] ?>" value="<? echo $factors_values_sort_arr[ $i ][ "Fact" ] ?>" class="text-tbldata"/></td>
					<?php } else { ?>
						<td><? echo $factors_values_sort_arr[ $i ][ "Fact" ] ?></td>
					<?php } ?>
<?php } ?>
					</tr>
<?
		}
	}
// представление c группировкой по папкам
}
?>
				</table>

				<div id="message-error"><?php getResource("message.filllesValue"); ?></div>

				<section id="box-paginator" class="box-paginator-table">
<?php if (!(null === $total || $total == 0) && $total > 1) {
	echo_panel_page($total, $page, $url,  false, 'input-action');
}?>

				</section>

				<section id="box-buttons">
					<span style="margin-right: 11px;"><button class="btn-top btn-top-text" title="<?php getResource("button.Save.hint");?>" id="btn-ok" type="submit"><span><i class="btn-top-text-icon btn-top-text-icon-ok"></i><?php getResource("button.Save");?></span></button></span>
					<span><button class="btn-top btn-top-text btn-cancel" title="<?php getResource("button.cancel.hint");?>" id="btn-cancel_2" type="button"><span><i class="btn-top-text-icon btn-top-text-icon-cancel"></i><?php getResource("button.cancel");?></span></button></span>
				</section>

			</form>
<?php 	} else { ?>
<br/>
<br/>
<div style="width: 100%;height:100%;position:relative;left:50%;margin-left:-100px;"><?php getResource("message.notEnablesInputs");?></div>
<br/>
<br/>
<?php 	} ?>
<?php 	} else { ?>
<br/>
<br/>
	<!--64873-->
	<div class="box-period" style="visibility: visible;">
		<div class="box-period-caption"><?php getResource("field.input.InputValues");?></div>
			<span>
				<a href="<?php echo urlReplaceParam(urlReplaceParam($url,'date_period', $avlble[0]),'pf', 1); ?>" class="input-action btn-top btn-top-text <?php if ($pf == 1) { echo 'btn-top-active'; }?>" title="<?php getResource("field.input.Plan");?>"><span><?php getResource("field.input.Plan");?></span></a><a href="<?php echo urlReplaceParam(urlReplaceParam($url,'date_period', $avlble[0]),'pf', 0); ?>" class="input-action btn-top btn-top-text <?php if ($pf == 0) { echo 'btn-top-active'; }?>" title="<?php getResource("field.input.Fact");?>"><span><?php getResource("field.input.Fact");?></span></a>
			</span>
		</div>
		<div class="" style="height: 5px;"></div>
	</div>
<br/>
<div style="width: 100%;height:100%;position:relative;left:50%;margin-left:-100px;"><?php getResource("message.notEnablesInputs");?></div>
<br/>
<br/>
<?php 	} ?>
<script src="js/box-caption-processor.js"></script>
<?php
if ( strlen($errmsg) > 0) {
	print '<script>';
	print 'alert("'. $errmsg.'")';
	print '</script>';
}
unset($trSt);
db_disconnect($cn);
ob_end_flush();
?>
