<?php
ob_start();
if(!(is_readable(realpath(dirname(__FILE__).'/../').'/include/includesroutines.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__).'/../').'/include/includesroutines.inc');
} else {
	include_once(realpath(dirname(__FILE__).'/../').'/include/includesroutines.inc');
}

if(!(is_readable(realpath(dirname(__FILE__).'/../').'/include/pagination.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__).'/../').'/include/pagination.inc');
} else {
	include_once(realpath(dirname(__FILE__).'/../').'/include/pagination.inc');
}

if(!(is_readable(realpath(dirname(__FILE__).'/../').'/include/includesroutinesadmin.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__).'/../').'/include/includesroutinesadmin.inc');
} else {
	include_once(realpath(dirname(__FILE__).'/../').'/include/includesroutinesadmin.inc');
}

if ( GetSetting('portal','useRights',0) == 1 && !IsUserLogin()){
	ob_end_flush();
	exit;
}
$cn = db_connect();
$contlng = null;
$contlngid = null;

if (getSetting('portal','useRights',0) == 1){
	$contlng = 'lang='.db_getLanguageShortByID($cn, $_SESSION['user_idlanguagecontent']);
	$contlngid = $_SESSION['user_idlanguagecontent'];
}

if (getCookieForPage('firstvisit') === NULL ) {
	setCookieForPage("firstvisit", TRUE);
	setCookieForPage('filter-active', TRUE);
	setCookieForPage('filter-stopped', TRUE);
	setCookieForPage('filter-notactive', TRUE);
}
$mainskbranch = db_getMainSKBranch($cn);

$onpage = getSetting('page', 'polls.pagesize', 20);
$default_order_column = getCookieForPage('order_column','updatedate'); 
$default_order_val = getCookieForPage('order_val','asc');
$polltypes = db_getPollTypesListAdmin($cn, $_SESSION['user_idlanguagecontent']);

// url parse and build
$order_column = isset( $_GET[ "order_column" ] ) ? $_GET[ "order_column" ] : $default_order_column;
$order_val = isset( $_GET[ "order_val" ] ) ? $_GET[ "order_val" ] : $default_order_val;
setCookieForPage("order_column", $order_column);
setCookieForPage("order_val", $order_val);
$page = isset( $_GET[ "page" ] ) ? $_GET[ "page" ] : 1;
$usr_arr = GetUserIDs();
$url = buildTableTitleURL( $order_column, $order_val, 'service/' );

setCookieForPage('filter-active', (isset($_REQUEST['filter-active']) ? 'filter-active' : NULL));
setCookieForPage('filter-stopped', (isset($_REQUEST['filter-stopped']) ? 'filter-stopped' : NULL));
setCookieForPage('filter-notactive', (isset($_REQUEST['filter-notactive']) ? 'filter-notactive' : NULL));

?>
	<table class="tbldata" cellspacing="0">
		<tr>
			<th class="<? if( $order_column == "source_name" ) echo "tbldata-cell-sortable" ?> tblinput-cell-name"><? echo buildSortColumnTitle( getResourceByLang('field.polls.survey'), ( $order_column == "source_name" ? true : false ), "source_name", $order_val, 'service/' ) ?></th>
			<th class="<? if( $order_column == "progress_percent" ) echo "tbldata-cell-sortable" ?> tblinput-cell-name nowrap"><? echo buildSortColumnTitle( getResourceByLang('field.polls.progress'), ( $order_column == "progress_percent" ? true : false ), "progress_percent", $order_val, 'service/' ) ?></th>
			<th class="tblinput-cell-name"><? echo getResourceByLang('field.polls.results'); ?></th>
			<th class="<? if( $order_column == "updatedate_tmst" ) echo "tbldata-cell-sortable" ?> tblinput-cell-name nowrap"><nobr><? echo buildSortColumnTitle( getResourceByLang('field.polls.updatedate'), ( $order_column == "updatedate_tmst" ? true : false ), "updatedate_tmst", $order_val, 'service/' ) ?></nobr></th>
			<th class="tblinput-cell-name nowrap"><? echo getResourceByLang('field.polls.details'); ?></th>
			<th class="tblinput-cell-name nowrap"><? echo getResourceByLang('field.polls.actions'); ?></th>
		</tr>
<?php
	db_prepareSQLBIGSELECT($cn);
	db_dropTempTable($cn, 'polls');
	
	$q_st = "CREATE TEMPORARY TABLE `polls` (
		`skpollingobject` INT NOT NULL,
		`skbranch` INT NOT NULL,
		`skproject` INT NULL,	
		`skpolltype` INT NOT NULL,
		`updatedate_tmst` INT NOT NULL,
		`progress` INT NOT NULL,
		`progress_of` INT NOT NULL,
		`startdate` VARCHAR(10) COLLATE utf8mb4_unicode_ci  NOT NULL,
	    `enddate` VARCHAR(10) COLLATE utf8mb4_unicode_ci  NOT NULL,		
		`status` TINYINT(4) NOT NULL,	
		`iduser` INT NOT NULL,	
		`hasanswer` TINYINT,
		PRIMARY KEY (`skpollingobject`, `skpolltype`, `iduser`),
		INDEX `skpollingobject` (`skpollingobject`),
		INDEX `skbranch` (`skbranch`),
		INDEX `skproject` (`skproject`)
		)ENGINE=MEMORY;";
	db_runQuery($cn, $q_st);
	
	if (isUserAdmin()) {
		$q_st = "INSERT IGNORE INTO `polls`
		SELECT DISTINCT po.`skpollingobject` as `skpollingobject`, po.`skbranch`, po.`skproject`, pt.`skpolltype`, 0 as `updatedate_tmst`, ua_w.`hasanswer` as `progress`,1 as `progress_of`, 
		prj.`startdate`, prj.`enddate` ,		
		ua_w.`idpollingobjectstatus`  as `status` ,  uu.`iduser` as `iduser`, ua_w.hasanswer
		  FROM `pollingobjects` po 
		  INNER JOIN useranswers as ua_w ON po.`skpollingobject` = ua_w.`skpollingobject`  
		  INNER JOIN `branches` br ON br.`skbranch` = po.`skbranch` 
		  INNER JOIN `polltypes` pt ON pt.`skpolltype` = ua_w.`skpolltype`
		  INNER JOIN `users` uu ON uu.`iduser` = ua_w.`iduser`
		  LEFT JOIN `projects` prj ON po.`skproject` = prj.`skproject`;";
		db_runQuery($cn, $q_st);
	} else {
		db_createUsersIDsTempTable($cn, $usr_arr);
		$q_st = "INSERT IGNORE INTO `polls`
		SELECT DISTINCT po.`skpollingobject` as `skpollingobject`, po.`skbranch`, po.`skproject`,pt.`skpolltype`, 0 as `updatedate_tmst`, ua_w.`hasanswer` as `progress`,1 as `progress_of`, 
		prj.`startdate`, prj.`enddate` ,		
		ua_w.`idpollingobjectstatus`  as `status` ,  ua_u.`iduser` as `iduser`, ua_w.hasanswer
		  FROM `pollingobjects` po 
		  INNER JOIN useranswers as ua_w ON po.`skpollingobject` = ua_w.`skpollingobject` 
		  INNER JOIN `rightspollingobjects` u ON po.`skpollingobject` = u.`skpollingobject` AND u.deny_allow = 1
		  INNER JOIN userids_t ut ON u.`iduser` = ut.`iduser` 
		  INNER JOIN `branches` br ON br.`skbranch` = po.`skbranch` 
		  INNER JOIN `polltypes` pt ON pt.`skpolltype` = ua_w.`skpolltype`
		  INNER JOIN `users` uu ON uu.`iduser` = ua_w.`iduser`
		  INNER JOIN `users` ua_u ON ua_u.`iduser` = ua_w.`iduser`
		  LEFT JOIN `projects` prj ON po.`skproject` = prj.`skproject`;";
		db_runQuery($cn, $q_st);

		$q_st = "INSERT IGNORE INTO `polls`
		SELECT DISTINCT  po.`skpollingobject` as `skpollingobject`, po.`skbranch`, po.`skproject`, pt.`skpolltype`, 0 as `updatedate_tmst`, ua_w.`hasanswer` as `progress`,1 as `progress_of`, 
		prj.`startdate`, prj.`enddate` ,		
		ua_w.`idpollingobjectstatus`  as `status` ,  ua_u.`iduser` as `iduser`, ua_w.hasanswer
		  FROM `pollingobjects` po 
		  INNER JOIN useranswers as ua_w ON po.`skpollingobject` = ua_w.`skpollingobject` 
		  INNER JOIN `polltypes` pt ON ua_w.`skpolltype` = pt.`skpolltype`
		  INNER JOIN `rightsadminpollingobjects` u ON pt.`skpolltype` = u.`skpolltype` AND u.deny_allow = 1 AND CASE WHEN ( u.`skproject` IS NULL or u.`skproject` = 0 ) THEN po.`skbranch` = u.`skbranch` ELSE po.`skproject` = u.`skproject` END
		  INNER JOIN userids_t ut ON u.`iduser` = ut.`iduser` 
		  INNER JOIN `branches` br ON br.`skbranch` = po.`skbranch` 
		  INNER JOIN `users` uu ON uu.`iduser` = u.`iduser`
		  INNER JOIN `users` ua_u ON ua_u.`iduser` = ua_w.`iduser`
		  LEFT JOIN `projects` prj ON po.`skproject` = prj.`skproject`;";
		db_runQuery($cn, $q_st);
	}
	$q_st = "UPDATE `polls` SET `skbranch` = 0 WHERE `skproject` IS NOT NULL;";
	db_runQuery($cn, $q_st);

	db_dropTempTable($cn, 'pollsresult');

	$q_st = " CREATE TEMPORARY TABLE `pollsresult` (
		`skbranch` INT NOT NULL,
		`skproject` INT NULL,	
		`idpolltype` varchar(250)  COLLATE utf8mb4_unicode_ci NOT NULL,
		`skpolltype` INT NOT NULL,
		`updatedate_tmst` INT NOT NULL,
		`progress` INT NOT NULL,
		`progress_percent` INT NOT NULL,
		`progress_of` INT NOT NULL,
		`source_name` varchar(2500)  COLLATE utf8mb4_unicode_ci  NOT NULL,
		`polltype_name` varchar(2500) COLLATE utf8mb4_unicode_ci  NOT NULL,
		`startdate` VARCHAR(10) COLLATE utf8mb4_unicode_ci  NOT NULL,
	    `enddate` VARCHAR(10) COLLATE utf8mb4_unicode_ci  NOT NULL,		
		`status` TINYINT(4) NOT NULL
		)ENGINE=MEMORY;";
	db_runQuery($cn, $q_st);

	$q_st = "INSERT INTO  `pollsresult` 
				SELECT `skbranch`, `skproject`, '' as idpolltype, `skpolltype`, `updatedate_tmst`, SUM(`progress`), 0 as `progress_persent`, SUM(`progress_of`), '' as source_name, '' as polltype_name, `startdate`, `enddate`, `status`
				FROM `polls` GROUP BY `skbranch`, `skproject`, `skpolltype`, `updatedate_tmst`, `startdate`, `enddate`, `status`;";
	db_runQuery($cn, $q_st);

	$q_st = "UPDATE `pollsresult` SET progress_percent = ROUND(progress * 1.0 / (progress_of * 1.0 / 100.0) , 0) ;";
	db_runQuery($cn, $q_st);

	$q_st = "UPDATE `pollsresult` INNER JOIN `polltypes` ON  `pollsresult`.skpolltype = `polltypes`.skpolltype
			    SET `pollsresult`.`idpolltype` = `polltypes`.idpolltype;";
	db_runQuery($cn, $q_st);

	$q_st = "UPDATE `pollsresult` INNER JOIN `resourcefromtables` ON `idrecord` = `skproject` AND `idtable` = 10 AND idlanguage = ".$contlngid."
			    SET `source_name` = rft_columnname_text
			 WHERE `skproject` IS NOT NULL;";
	db_runQuery($cn, $q_st);

	$q_st = "UPDATE `pollsresult` INNER JOIN `resourcefromtables` ON `idrecord` = `pollsresult`.`skbranch` AND `idtable` = 7 AND idlanguage = ".$contlngid."
			    SET `source_name` = rft_columnname_text
			 WHERE `skproject` IS NULL;";
	db_runQuery($cn, $q_st);

	$q_st = "UPDATE `pollsresult` INNER JOIN `resourcefromtables` ON `idrecord` = `skpolltype` AND `idtable` = 8 AND idlanguage = ".$contlngid."
				SET `polltype_name` = rft_columnname_text
		 	  WHERE `skpolltype` IS NOT NULL;";
	db_runQuery($cn, $q_st);

	$q_st = "UPDATE `pollsresult` p INNER JOIN (SELECT `skbranch`, CASE WHEN  MAX(IFNULL(objectversiondate_tmst,0)) > MAX(IFNULL(reportversiondate_tmst,0)) THEN MAX(IFNULL(objectversiondate_tmst,0)) ELSE MAX(IFNULL(reportversiondate_tmst,0)) END AS updatedate_tmst
				FROM `pollingobjects`
				GROUP BY `skbranch`) po ON po.`skbranch` = p.`skbranch` 
			SET p.`updatedate_tmst` = po.updatedate_tmst;";
	db_runQuery($cn, $q_st);

	$q_st = "UPDATE `pollsresult` p INNER JOIN (SELECT `skproject`, CASE WHEN  MAX(IFNULL(objectversiondate_tmst,0)) > MAX(IFNULL(reportversiondate_tmst,0)) THEN MAX(IFNULL(objectversiondate_tmst,0)) ELSE MAX(IFNULL(reportversiondate_tmst,0)) END AS updatedate_tmst
				FROM `pollingobjects` WHERE `skproject` IS NOT NULL
				GROUP BY `skproject` ) po ON po.`skproject` = p.`skproject`  
			SET p.`updatedate_tmst` = po.updatedate_tmst;";
	db_runQuery($cn, $q_st);

	$resarr = array();

	$q_st = "SELECT COUNT(0) as cnt FROM (SELECT distinct * FROM `pollsresult`) Q";
	$resarr = db_runQueryAndReturnArray($cn,$q_st);
	$total = $resarr[0]['cnt'];
	$total = ceil($total/$onpage); 
	$total = $total == 0 ? 1 : $total;
	$page = (($page > $total) ? $total : $page);

	db_setTimeZone($cn);

	$q_st = 'SELECT *, DATE_FORMAT(startdate, \'%d.%m.%Y\') as startdateformated, DATE_FORMAT(enddate, \'%d.%m.%Y\') as enddateformated, DATE_FORMAT(from_unixtime(updatedate_tmst), "%d.%m.%Y") as updatedate FROM `pollsresult` ';
	$filter_skpolltype = ' 1 = 2 '; //Task 59710
	$filter_status = ' status = -1 ';
	$filter_percent = '';
	$filter = '';

	foreach ( $_REQUEST as $key => $value ) {
		$ind = stripos($key,'filter-skpolltype_');
		if ($ind !== false) {
			$filter_skpolltype .=  ($filter_skpolltype == '' ? '' : ' OR ' ).'skpolltype = '.substr($key, $ind + strlen('filter-skpolltype_'));
		}
	}

	$filter = ($filter_skpolltype == '' ? '' : ' WHERE ( '.$filter_skpolltype.')');
	
	foreach($_GET as $key => $value){
		if (strpos($key, 'filter-status-') !== false) {
			$filter_status .= ($filter_status == '' ? '' : ' OR ' ).' status = '.str_replace('filter-status-', '', $value).' ';
		}
	}
	
	if ($filter === '' && $filter_status !== ''){
		$filter = ' WHERE ( '.$filter_status.')';
	} else if ($filter !== '' && $filter_status !== ''){
		$filter = $filter.' AND ( '.$filter_status.')';
	}

	setCookieForPage('filter-uncompleted', NULL);
	setCookieForPage('filter-completed', NULL);

	$filter_percent = ' progress_percent = -1 ';
	if (isset($_REQUEST['filter-completed']) && isset($_REQUEST['filter-uncompleted'])){
		setCookieForPage('filter-completed', 'filter-completed');
		setCookieForPage('filter-uncompleted', 'filter-uncompleted');
		$filter_percent = ' progress_percent != -1 ';
	} else if (isset($_REQUEST['filter-completed'])){
		$filter_percent = ' progress_percent = 100 ';
		setCookieForPage('filter-completed', 'filter-completed');
	} else if (isset($_REQUEST['filter-uncompleted'])){
		$filter_percent = ' progress_percent < 100 ';
		setCookieForPage('filter-uncompleted', 'filter-uncompleted');
	}


	if ($filter === '' && $filter_percent !==''){
		$filter = ' WHERE ( '.$filter_percent.')';
	} else if ($filter !== '' && $filter_percent !== ''){
		$filter = $filter.' AND ( '.$filter_percent.')';
	}

	$q_st.= $filter;

	if ($order_column != "") {
		$q_st.= " ORDER BY ".$order_column."  ".$order_val." ";
	}
	$q_st.= "LIMIT ".(($page - 1) * $onpage).",".$onpage.";";

	$resarr = db_runQueryAndReturnArray($cn,$q_st);
	
	$size=sizeof($resarr);
	$adminpollpage = (isset($_COOKIE['adminpollpage']) ? $_COOKIE['adminpollpage'] : 'adminpoll');

	for($i=0; $i<$size; $i++){
			?>
			<tr>
				<td valign="top" class="clear-padding">
					<table class="in-row-table" cellspacing="0" cellpadding="0">
						<tr>
							<td valign="top" class="in-row-table-td"><? echo '<a href="'.$adminpollpage.'.php?&idpolltype='.$resarr[ $i ][ "idpolltype" ]."&".($resarr[ $i ][ "skbranch" ] == 0 ? 'skproject='.$resarr[ $i ][ "skproject" ] : 'skbranch='.$resarr[ $i ][ "skbranch" ]).'">'.$resarr[ $i ][ "polltype_name" ].': '.$resarr[ $i ][ "source_name" ].'</a>'; ?></td>
							<td valign="middle" class="in-row-table-td hright">
								<nobr>
									<i title="<? echo getResourceByLang('button.poll.instruction.hint') ?>" 
									<? echo 'href="skpolltype-html'.$resarr[ $i ][ "skpolltype" ].'"'?> class="dialog-html-show-link fal fa-question-circle font-awesome-color font-awesome-size">
									</i>
								</nobr>
							</td>
						</tr>
					</table>					
				</td>
				<td valign="top" class="nowrap"><nobr><? echo $resarr[ $i ][ "progress_percent" ]."% (".$resarr[ $i ][ "progress" ]." / ".$resarr[ $i ][ "progress_of"].")"; ?></nobr></td>
				<td valign="top" class="nowrap"><?php 
						$answersvals = [];
						$polltypeQuestionType = db_getPolltypeQuestionType($cn, $resarr[ $i ]['skpolltype']);

						db_dropTempTable($cn, 'pollanswers');
	
						$q_st = "CREATE TEMPORARY TABLE `pollanswers` (
							`skpollingobject` INT NOT NULL,
							`skpolltype` INT NOT NULL,
							INDEX `skpollingobject` (`skpollingobject`),
							INDEX `skpolltype` (`skpolltype`)
							)ENGINE=MEMORY;";
						db_runQuery($cn, $q_st);

						$q_st = 'INSERT INTO pollanswers SELECT DISTINCT skpollingobject, skpolltype  FROM `polls` WHERE hasanswer != 0 AND skpolltype = '.$resarr[ $i ]['skpolltype'].' ';
						if (isset($resarr[ $i ]['skproject']) && $resarr[ $i ]['skproject'] != 0 ) {
                                $q_st .= " AND skproject = ".$resarr[ $i ]['skproject']." ";
                        } else {
                                $q_st .= " AND skbranch = ".$resarr[ $i ]['skbranch']." ";
						}	
						db_runQuery($cn, $q_st);

						$q_st = "SELECT uav.uav_value, COUNT(0) as cnt
								 FROM useranswersvalues as uav 
								 INNER JOIN `pollanswers` pa ON uav.skpollingobject = pa.skpollingobject AND uav.skpolltype = pa.skpolltype AND uav.uav_value !=0
								 GROUP BY uav.uav_value ORDER BY cnt DESC; ";
						$answers = db_runQueryAndReturnArray($cn,$q_st);
						for($j=0; $j<sizeof($answers); $j++){
							if ($polltypeQuestionType[0]['idpolltypequestiontype'] == 1){
								echo '<div class="resrondents-table-answer"><nobr>'
								.db_getPolltypeQuestionValueByID($cn, $polltypeQuestionType[0]['skpolltypequestion'], $contlngid) /*65036*/
								.': '.$answers[$j]['cnt']
								."</nobr></div>"; //61932
							} else {
								echo '<div class="resrondents-table-answer"><nobr>'
								.db_getQuestionSelectValueByID($cn, $polltypeQuestionType[0]['skpolltypequestion'], $answers[$j]['uav_value'], $contlngid)
								.': '.$answers[$j]['cnt']
								."</nobr></div>"; //61932
							}
						}
				?></td>
				<td valign="top" class="nowrap"><? echo $resarr[ $i ][ "updatedate" ] ?></td>
				<td valign="top" class="nowrap">
					<? $status = $resarr[ $i ][ "status" ]; 
						$prjlink = "";
						$finishdate = "";
						if ($resarr[ $i ][ "skbranch" ] == 0 ) {
							$prj = db_getProjectBySkProject($cn, $resarr[ $i ][ "skproject"]);
							if (is_array($prj) && sizeof($prj) > 0 && db_isObjectExits($cn, $prj[0]["idproject"], $mainskbranch) && db_getUserRightsToObject($cn, $usr_arr,  $prj[0]["idproject"])) {
								$prjlink = getCurPageURLWO('service')."businessmodel.php?oguid=".$prj[0]["idproject"]; 
							}
							$finishdate = db_getPollFinishDateBySkroject($cn, $resarr[ $i ][ "skpolltype"], $resarr[ $i ][ "skproject" ]);
						} else {
							$finishdate = db_getPollFinishDateBySkBranch($cn, $resarr[ $i ][ "skpolltype"], $resarr[ $i ][ "skbranch" ]);
						}
						echo '<table class="project-description" >';
						echo "<tr><td>".getResourceByLang("title.polls.status").":&nbsp;</td><td>".getResourceByLang("title.polls.status.".$status).'</td></tr>'
						.($finishdate != "" 
							? '<tr><td>'.getResourceByLang("title.poll.finishdate").':&nbsp;</td><td>'.$finishdate.'</td></tr>'
							: '')
						."<tr><td>".getResourceByLang("field.polls.source").":&nbsp;</td><td>"
							.($resarr[ $i ][ "skbranch" ] == 0 
							? ($prjlink == "" ? getResourceByLang("title.polls.source.project") : "<a href='".$prjlink."' target='_parent'>".getResourceByLang("title.polls.source.project")."</a>")
							: getResourceByLang("title.polls.source.branch") )
						.'</td></tr>'
						.'</table>'; 
					?>
				</td>
				<td valign="top" class="nowrap"><?php renderPollStatusChangeLinks($cn, $usr_arr, $resarr[ $i ]['idpolltype'], $resarr[ $i ]['skpolltype'], (isset($resarr[ $i ]['skproject']) ? $resarr[ $i ]['skproject'] : NULL),  (isset($resarr[ $i ]['skbranch']) ? $resarr[ $i ]['skbranch'] : NULL),$resarr[ $i ][ "status" ]);?></td>
			</tr>
		<?php
		}
?>
				</table>

				
<?php if (!(null === $total || $total == 0) && $total > 1) {?>
				<section id="box-paginator" class="box-paginator-table">
				<?php echo_panel_page($total, $page, $url);?>
				</section>
<?php } ?>

<?php
	$q_st = 'SELECT DISTINCT `polls`.skpolltype, res_pt.rft_columnname_long as polltype_description     
		   FROM `polls` LEFT JOIN  `resourcefromtables` res_pt ON `skpolltype` = res_pt.`idrecord` AND res_pt.`idtable` = 801 AND res_pt.idlanguage = '.$contlngid.' ;';
	
	$resarr = db_runQueryAndReturnArray($cn,$q_st);
	$size=sizeof($resarr);

	for($i=0; $i<$size; $i++){
		?>
		<div id="skpolltype-html<? echo $resarr[ $i ][ "skpolltype" ]?>" class="dialog" style="min-width:50%; min-height:80%;">
			<div id="dialog-titlebar" class="titlebar"></div>
			<div class="content">
			<? echo $resarr[ $i ][ "polltype_description" ]?>
			</div>
			<div class="buttonpane">
				<div class="buttonset">
				<button id="dialog-box-button-cancel" class="btn-top btn-top-text" title="<?php getResource("button.close.hint");?>"><span><?php getResource("button.close");?></span></button>
				</div>
			</div>
		</div>		
	<?php }?>
<?php 
db_disconnect($cn);
ob_end_flush(); 
?>