<?php
ob_start();
if(!(is_readable(realpath(dirname(__FILE__)).'/include/includesroutines.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/includesroutines.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/includesroutines.inc');
}

if(!(is_readable(realpath(dirname(__FILE__)).'/include/pagination.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/pagination.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/pagination.inc');
}

checkUserAndRedirectToLogin();
RedirectToModelAnonymous();

if(!(is_readable(realpath(dirname(__FILE__)).'/include/bsservice.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/bsservice.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/bsservice.inc');
}

if(!(is_readable(realpath(dirname(__FILE__)).'/include/filterbuttons.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/filterbuttons.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/filterbuttons.inc');
}

$cn = db_connect();
$url = getCurPageURL();
$contlngid = $_SESSION['user_idlanguagecontent'];
$lng_shot = db_getLanguageShortByID($cn, $contlngid);
if (isset($_REQUEST['idbranch'])) {
	$idbranch = $_REQUEST['idbranch'];
	$skbranch = db_getSKBranch($cn,$idbranch);	
} else {
	$skbranch = db_getMainSKBranch($cn);
	$idbranch = db_getMainIDBranch($cn);	
}

$usr_arr = GetUserIDs();
$polltypes = db_getPollTypesList($cn, $_SESSION['user_idlanguagecontent'], $usr_arr[0]);

if (getCookieForPage('firstvisit') === NULL ) {
	setCookieForPage("firstvisit", TRUE);
	setCookieForPage('filter-active', TRUE);
	for($i=0; $i<sizeof($polltypes); $i++){
		$skpolltype = 'filter-skpolltype_'.$polltypes[$i]['skpolltype'];
		setCookieForPage($skpolltype, $skpolltype);
	}
	header("Location: ".getCurPageURL());
	ob_end_flush();
	exit;
}

$urlFromCookies = getCurPageURL();
if(sizeof($_REQUEST) == 0) {
	if (getCookieForPage('filter-completed') === NULL && getCookieForPage('filter-uncompleted') === NULL ) {
		$urlFromCookies = urlReplaceParam($urlFromCookies,'filter-uncompleted', 'filter-uncompleted');
	}
	
	if (getCookieForPage('filter-completed') !== NULL ) {
		$urlFromCookies = urlReplaceParam($urlFromCookies,'filter-completed', 'filter-completed');
	}
	
	if (getCookieForPage('filter-uncompleted') !== NULL ) {
		$urlFromCookies = urlReplaceParam($urlFromCookies,'filter-uncompleted', 'filter-uncompleted');
	}

	if (getCookieForPage('filter-active') !== NULL ) {
		$urlFromCookies = urlReplaceParam($urlFromCookies,'filter-active', 'filter-active');
	}

	if (getCookieForPage('filter-stopped') !== NULL ) {
		$urlFromCookies = urlReplaceParam($urlFromCookies,'filter-stopped', 'filter-stopped');
	}

	if (getCookieForPage('filter-notactive') !== NULL ) {
		$urlFromCookies = urlReplaceParam($urlFromCookies,'filter-notactive', 'filter-notactive');
	}

	for($i=0; $i<sizeof($polltypes); $i++){
		$skpolltype = 'filter-skpolltype_'.$polltypes[$i]['skpolltype'];
		if (getCookieForPage($skpolltype) !== NULL ) {
			$urlFromCookies = urlReplaceParam($urlFromCookies, $skpolltype, $skpolltype);
		} else {
			$sknownpolltype = 'known-skpolltype_'.$polltypes[$i]['skpolltype'];  //63391
			if (getCookieForPage($sknownpolltype) === NULL ) {
				$urlFromCookies = urlReplaceParam($urlFromCookies, $skpolltype, $skpolltype);
				setCookieForPage($sknownpolltype, $sknownpolltype);
			}
		}
	}
		
	if( $urlFromCookies !== getCurPageURL() ){
		header("Location: ".$urlFromCookies);
		ob_end_flush();
		exit;
	}
} else {
	//65936
	for($i=0; $i<sizeof($polltypes); $i++){
		$skpolltype = 'filter-skpolltype_'.$polltypes[$i]['skpolltype'];
		//70267
		$sknownpolltype = 'known-skpolltype_'.$polltypes[$i]['skpolltype'];  //63391
		if (getCookieForPage($sknownpolltype) === NULL ) {
			$urlFromCookies = urlReplaceParam($urlFromCookies, $skpolltype, $skpolltype);
			setCookieForPage($sknownpolltype, $sknownpolltype);
			setCookieForPage($skpolltype, $skpolltype);
		}
	}
	if( $urlFromCookies !== getCurPageURL() ){
		header("Location: ".$urlFromCookies);
		ob_end_flush();
		exit;
	}
}

// settings
$onpage = getSetting('page', 'polls.pagesize', 20);
$default_order_column = getCookieForPage('order_column','updatedate'); 
$default_order_val = getCookieForPage('order_val','asc');
// url parse and build
$order_column = isset( $_GET[ "order_column" ] ) ? $_GET[ "order_column" ] : $default_order_column;
$order_val = isset( $_GET[ "order_val" ] ) ? $_GET[ "order_val" ] : $default_order_val;
setCookieForPage("order_column", $order_column);
setCookieForPage("order_val", $order_val);

$page = isset( $_GET[ "page" ] ) ? $_GET[ "page" ] : 1;
$url = buildTableTitleURL( $order_column, $order_val );

setCookieForPage('filter-active', NULL);
setCookieForPage('filter-stopped', NULL);
setCookieForPage('filter-notactive', NULL);

if (isset($_REQUEST['filter-active'])) {
	setCookieForPage('filter-active', 'filter-active');
}
if (isset($_REQUEST['filter-stopped'])) {
	setCookieForPage('filter-stopped', 'filter-stopped');
}
if (isset($_REQUEST['filter-notactive'])) {
	setCookieForPage('filter-notactive', 'filter-notactive');
}

setCookieForPage('filter-uncompleted', NULL);
setCookieForPage('filter-completed', NULL);

if (isset($_REQUEST['filter-completed']) && isset($_REQUEST['filter-uncompleted'])){
	setCookieForPage('filter-completed', 'filter-completed');
	setCookieForPage('filter-uncompleted', 'filter-uncompleted');
} else if (isset($_REQUEST['filter-completed'])){
	setCookieForPage('filter-completed', 'filter-completed');
} else if (isset($_REQUEST['filter-uncompleted'])){
	setCookieForPage('filter-uncompleted', 'filter-uncompleted');
}

?>
<!doctype html>
<html>
<head>
	<title><?php echo renderTitle();?></title>
	<? 
	renderCommonMeta(renderTitle()); 
	renderCommonCSS(); 
	?>
	<link rel="stylesheet" href="css/zDater.css">
</head>
<body>
	<?php renderModalHourGlassDiv();?>
	<div id="container">
	<header id="header-container" class="ui-layout-north">
	<?php renderLoginBlock(); ?>
	</header>
	<div id="main" role="main" class="ui-layout-center">
		<?php renderMainMenu(); ?>
		<div id="content" class="ui-layout-center">
			<section id="box-input" class="clearfix">
				<div id="box-input-container">
					<div class="box-period">
						<div class="box-period-caption"><?php getResource("title.polls.progress");?></div>
						<span>
							<?php 
								echo buildFilterButton(getResourceByLang("title.polls.progress.completed"), 'filter-completed', isset($_REQUEST['filter-completed']), $order_column, $order_val, $page );
								echo buildFilterButton(getResourceByLang("title.polls.progress.uncompleted"), 'filter-uncompleted', isset($_REQUEST['filter-uncompleted']), $order_column, $order_val, $page );
							?>
						</span>
					</div>

					<div class="box-period">
						<div class="box-period-caption"><?php getResource("title.polls.type");?></div>
						<span>
							<?php
							for($i=0; $i<sizeof($polltypes); $i++){
								$skpolltype = 'filter-skpolltype_'.$polltypes[$i]['skpolltype'];
								$sknownpolltype = 'known-skpolltype_'.$polltypes[$i]['skpolltype'];  //63391
								setCookieForPage($skpolltype, NULL);
								if (isset($_REQUEST[$skpolltype])) {
									setCookieForPage($skpolltype, $skpolltype);
								}	
								echo buildFilterButton(	$polltypes[$i]['name'], $skpolltype, isset($_REQUEST[$skpolltype]), $order_column, $order_val, $page, getSetting('page', 'polls.buttontype.symbolscount', 0) );
							}
							?>
						</span>
					</div>

					<div class="box-period">
						<div class="box-period-caption"><?php getResource("title.polls.status");?></div>
						<span>
							<?php 
								echo buildFilterButton(getResourceByLang("title.polls.status.1"), 'filter-active', isset($_REQUEST['filter-active']), $order_column, $order_val, $page );
								echo buildFilterButton(getResourceByLang("title.polls.status.0"), 'filter-stopped', isset($_REQUEST['filter-stopped']), $order_column, $order_val, $page );
							?>
						</span>
					</div>
					<div class="" style="height: 5px;"></div>				
				</div>
				<div id="box-input-container" name="box-input-container">
					<div id="loadingbox" name="loadingbox" style="font-weight: bolder;padding-top: 40px;padding-bottom: 40px;"></div>
				</div>
			</section>
		</div>
	</div>
</div>
<script src="js/libs/jquery.cookie.js"></script>
<script src="js/script.js"></script>
<script src="js/libs/drDialog/drdialog.js"></script>
<link rel="stylesheet" href='js/libs/drDialog/drdialog.css' />
<script src="js/dialoglinks.js"></script>
<script src="js/dotloader.js"></script>
<script src="js/box-caption-processor.js"></script>
<script>
	ShowModalWindow();
	var loadingtext = '<?php getResource("title.loading");?>';
	var params = location.search;
	$(function(){
		startLoadAndSwohDotsRun(loadingtext, "#loadingbox", 8, 500);

		$.ajax({
				type: "GET",
				url: ("service/polls.php" + params),
				success: function(arg){
					var msg = arg;
					if ( msg.toString().length > 0 ) {
						$("#box-input-container").append(msg);
						initDialogLinks();
						$( window ).resize();
						$("a").not(".self-event").click( function() { ShowModalWindow();});					
					}
				},
				complete:function(arg){
					stopLoadAndSwohDotsRun();
					$("#loadingbox").remove();
					ShowModalWindow(false);
				}
			});	
	});
</script>
<?php
	if(!(is_readable(realpath(dirname(__FILE__)).'/templates/languagesbox.template'))) {
		die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/templates/languagesbox.template');
	} else {
		include_once(realpath(dirname(__FILE__)).'/templates/languagesbox.template');
	}
?>

<?php renderFooterTemplate(); ?>

</body>
</html>

<?php
unset($trSt);
db_disconnect($cn);
ob_end_flush();
?>
