<?php
if(!(is_readable(realpath(dirname(__FILE__))."/loginroutines.inc"))) {
	die("Error - Could not open or read file ".realpath(dirname(__FILE__))."/loginroutines.inc");
} else {
	include_once(realpath(dirname(__FILE__))."/loginroutines.inc");
}

// параметр фасад передается как часть пути
if(!(is_readable(realpath(dirname(__FILE__))."/db/mysqlroutines.common.inc"))) {
	die("Error - Could not open or read file ".realpath(dirname(__FILE__))."/db/mysqlroutines.common.inc");
} else {
	include_once(realpath(dirname(__FILE__))."/db/mysqlroutines.common.inc");
}

if(!(is_readable(realpath(dirname(__FILE__))."/translate.inc"))) {
	die("Error - Could not open or read file ".realpath(dirname(__FILE__))."/translate.inc");
} else {
	include_once(realpath(dirname(__FILE__))."/translate.inc");
}

if(!(is_readable(realpath(dirname(__FILE__))."/content.inc"))) {
	die("Error - Could not open or read file ".realpath(dirname(__FILE__))."/content.inc");
} else {
	include_once(realpath(dirname(__FILE__))."/content.inc");
}

function rememberGuidsInSession(){
	unset($_SESSION['remember_oguid']);
	unset($_SESSION['remember_rguid']);
	if (isset($_REQUEST['oguid'])){
		$_SESSION['remember_oguid'] = $_REQUEST['oguid'];
	}
	if (isset($_REQUEST['rguid'])){
		$_SESSION['remember_rguid'] = $_REQUEST['rguid'];
	}
}

function RedirectToModelAnonymous(){
	if ( getSetting('portal','useRights',0) == 0 ){
		header("Location: ".getCurPageURLWO()."/businessmodel.php");
		ob_end_flush();
		exit;
	}
}

function RedirectToPageNotFound(){
	header("Location: ".getCurPageURLWO()."/pagenotfound.php?url=".getCurPageWithEncodeParams());
	ob_end_flush();
	exit;
} 

function checkUserAndRedirectToLogin(){
	if (getSetting('portal','useRights',0) == 1) {
		$cn = db_connect();
		$skey = db_getPortalSessionKey($cn);
		db_disconnect($cn);
		unset($cn);
		if (!isset($_SESSION['portal_sessionkey']) || $_SESSION['portal_sessionkey'] != $skey ){
			clearResource();
			$lng = ( isset($_REQUEST['lang']) ? 'lang='.$_REQUEST['lang'] : '');
			if (basename($_SERVER['SCRIPT_NAME'], ".php") != 'login') {
				header("Location: login.php?".$lng."&returl=".getCurPageWithEncodeParams());
				ob_end_flush();
				exit;
			}
		}
	}
}

function getFileExtension($filename) {
    return pathinfo($filename, PATHINFO_EXTENSION);
}

function setCookieMobileMode($mode){
	setCookieLong('mobilemode', $mode);
}

function setCookieAdminLastPage($page){
	setCookieLong('last_admin_page', $page);
}

function setCookieHideHeader($mode){
	setCookieLong('hideheader', $mode);
}

function isMobileBrouser(){
	$agent = ( isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '' );
	$iphone = strpos($agent,"iPhone");
	$ipad  = strpos($agent,"iPad");
	$android = strpos($agent,"Android");
	$palmpre = strpos($agent,"webOS");
	$berry = strpos($agent,"BlackBerry");
	$ipod = strpos($agent,"iPod");
	$mobile = strpos($agent,"Mobile");
	$symb = strpos($agent,"Symbian");
	$operam = strpos($agent,"Opera M");
	$htc = strpos($agent,"HTC_");
	$fennec = strpos($agent,"Fennec/");
	$winphone = strpos($agent,"WindowsPhone");
	$wp7 = strpos($agent,"WP7");
	$wp8 = strpos($agent,"WP8");
	return ($ipad || $iphone || $android || $palmpre || $ipod || $berry || $mobile || $symb || $operam || $htc || $fennec || $winphone || $wp7 || $wp8 );
}

function isSearchBot(){
	  $USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
	  $engines = array(
		  array('Aport', 'Aport robot'),
		  array('Google', 'Google'),
		  array('msnbot', 'MSN'),
		  array('Rambler', 'Rambler'),
		  array('Yahoo', 'Yahoo'),
		  array('AbachoBOT', 'AbachoBOT'),
		  array('accoona', 'Accoona'),
		  array('AcoiRobot', 'AcoiRobot'),
		  array('ASPSeek', 'ASPSeek'),
		  array('CrocCrawler', 'CrocCrawler'),
		  array('Dumbot', 'Dumbot'),
		  array('FAST-WebCrawler', 'FAST-WebCrawler'),
		  array('GeonaBot', 'GeonaBot'),
		  array('Gigabot', 'Gigabot'),
		  array('Lycos', 'Lycos spider'),
		  array('MSRBOT', 'MSRBOT'),
		  array('Scooter', 'Altavista robot'),
		  array('AltaVista', 'Altavista robot'),
		  array('WebAlta', 'WebAlta'),
		  array('IDBot', 'ID-Search Bot'),
		  array('eStyle', 'eStyle Bot'),
		  array('Mail.Ru', 'Mail.Ru Bot'),
		  array('Scrubby', 'Scrubby robot'),
		  array('Yandex', 'Yandex'),
		  array('YaDirectBot', 'Yandex Direct')
	  );

	  foreach ($engines as $engine) {
	  	if (strstr($USER_AGENT, $engine[0])){
	  		return($engine[1]);
	  	}
	  }
	  return false;
}

if (!isset($_COOKIE['mobilemode'])){
	setCookieMobileMode( (isMobileBrouser() ? 1 : 0) );
}

function validateDateTime($date, $format = 'd.m.Y H:i:s')
{
    $d = DateTime::createFromFormat($format, $date);
    $res = false;
    $res = $d && $d->format($format) == $date;
    return $res;
}

function validateDate($date, $format = 'd.m.Y')
{
    return validateDateTime($date, $format);
}

function setCookieLong($name, $value){
	setcookie($name, $value, time() + (86400 * 365));
}

function setCookieForPage($name, $value){
	$cookiename = ucfirst(pathinfo($_SERVER['PHP_SELF'], PATHINFO_FILENAME)).'_'.$name;
	if (!isset($value) || $value === NULL){
		unset($_COOKIE[$cookiename]);
		setcookie($cookiename, '', time()-3600);
	} else {
		setCookieLong($cookiename, $value);
	}
}

function getCookieForPage($name, $defaulvalue = NULL){
	$cookiename = ucfirst(pathinfo($_SERVER['PHP_SELF'], PATHINFO_FILENAME)).'_'.$name;
	return (isset($_COOKIE[$cookiename]) ? $_COOKIE[$cookiename] : $defaulvalue); 
}

header('P3P:CP="IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT"');
header("Cache-Control: private, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); 
Header("Last-Modified: ".gmdate("D, d M Y H:i:s")."GMT");

checkLanguage();

?>