<?php
ob_start();
if(!(is_readable(realpath(dirname(__FILE__)).'/include/includesroutines.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/includesroutines.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/includesroutines.inc');
}

// если не передано ничего про файл
if (!isset($_REQUEST['rguid']) && !isset($_REQUEST['oguid']) && !isset($_REQUEST['name'])) {
	echoNotRigths();
	ob_end_flush();
	exit;
}
$cn = db_connect();
if (isset($_REQUEST['lang']))
{
	$lng = 'lang='.$_REQUEST['lang'];
	$contlngid = db_getLanguageID($cn, $_REQUEST['lang']);
	$contlng = $lng;
} else {
	$contlng = 'lang='.db_getLanguageShortByID($cn, $_SESSION['user_idlanguagecontent']);
	$contlngid = $_SESSION['user_idlanguagecontent'];
}
$uoguid = (isset($_REQUEST['oguid']) ? urldecode($_REQUEST['oguid']) : '') ;
$urguid = (isset($_REQUEST['rguid']) ? urldecode($_REQUEST['rguid']) : '') ;
$name = (isset($_REQUEST['name']) ? urldecode($_REQUEST['name']) : '') ;
$folderext = (isset($_REQUEST['folderext']) ? $_REQUEST['folderext'] : '') ;
$flroot = getSetting('storage','fileroot',realpath(dirname(__FILE__)).'/data/');
if (isset($_REQUEST['idbranch'])) {
	$idbranch = $_REQUEST['idbranch'];
	$skbranch = db_getSKBranch($cn,$idbranch);	
} else {
	$skbranch = db_getMainSKBranch($cn);
	$idbranch = db_getMainIDBranch($cn);	
}
if (db_isObjectsMultianguage($cn, $uoguid, $urguid, $skbranch)){
	$lang_short = NULL;
} else {
	if (db_isLanguageValidByID($cn, $contlngid)){
		$lang_short = db_getLanguageShortByID($cn, $contlngid);
	} else {
		$lang_short = 'falseLang';
	}	
}

$filename = nameReportWithBranchAndLanguage($flroot, $uoguid, $urguid, $lang_short, $idbranch, $folderext.'/'.$name);
if (!file_exists($filename)){
	http_response_code(404);
	header('Temporary-Header: True', true, 404);
	ob_end_flush();
	exit;
}

if ( GetSetting('portal','useRights',0) == 1 ){
	if( !IsUserLogin() ){
		http_response_code(404);
		header('Temporary-Header: True', true, 404);
		ob_end_flush();
		exit;
	} else {
		$userids = GetUserIDs();
		if (!isset($_REQUEST['rguid'])){
	  		$trSt = db_getReportsToObject($cn, $uoguid , $userids, $lngid, $contlngid, $skbranch);
			if (sizeof($trSt) > 0 ) {
				$rguid = $trSt[0]['r_guid'];
			}
		}
		if (db_getUserRightsToObject($cn, GetUserIDs(), $uoguid, $skbranch) === null || db_getUserRightsToReport($cn, $userids, $urguid, $uoguid, $contlngid, $skbranch) === null ) {
			http_response_code(404);
			header('Temporary-Header: True', true, 404);
			db_disconnect($cn);
			ob_end_flush();
			exit;
		}
	}
}
if ( strlen($filename) > 10 ){
	$Cnttype = "Content-type: image/";
	$path_parts = pathinfo($filename);
	switch (mb_strtoupper($path_parts['extension']))
	{
		case "GIF":	 	$Cnttype = $Cnttype."gif"; break;
		case "JPG":
		case "JPEG": 	$Cnttype = $Cnttype."jpeg"; break;
		case "PJPG":
		case "PJPEG": 	$Cnttype = $Cnttype."pjpeg"; break;
		case "PNG": 	$Cnttype = $Cnttype."png"; break;
		case "TIFF": 	$Cnttype = $Cnttype."tiff"; break;
		case "SVG": 	$Cnttype = $Cnttype."svg+xml"; break;
		case "ICO": 	$Cnttype = $Cnttype."vnd.microsoft.icon"; break;
		case "WBMP": 	$Cnttype = $Cnttype."vnd.wap.wbmp"; break;
		default:		$Cnttype = $Cnttype."jpeg";
	}
	header($Cnttype);
	header("Content-Length: " . filesize($filename));
	$fp = fopen($filename, 'rb');
	fpassthru($fp);
}