<?php
ob_start();
if(!(is_readable(realpath(dirname(__FILE__)).'/include/includesroutines.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/includesroutines.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/includesroutines.inc');
}

if(!(is_readable(realpath(dirname(__FILE__)).'/include/bsservice.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/bsservice.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/bsservice.inc');
}

checkUserAndRedirectToLogin();

$cn = db_connect();
$contlng = null;
$contlngid = null;
if (getSetting('portal','useRights',0) == 1){
	$contlng = 'lang='.db_getLanguageShortByID($cn, $_SESSION['user_idlanguagecontent']);
	$contlngid = $_SESSION['user_idlanguagecontent'];
}

$logfile = realpath(dirname(__FILE__)).'/log/portal.log';
$hideheader = (isset($_COOKIE['hideheader']) ?  $_COOKIE['hideheader'] : 0);

if ( GetSetting('portal','useRights',0) == 0 ){
	if( !IsUserLogin() ){
		header("Location: ".getCurPageURLWO()."/businessmodel.php");
		ob_end_flush();
		exit;
	}
} else {
	if( !IsUserLogin() ){
		header("Location: ".getCurPageURLWO()."/login.php?returl=adminconsole.php");
		ob_end_flush();
		exit;
	}
	$cn = db_connect();
	if (!isUserAdmin()){ 
		if (db_isUserAdminToPolls($cn, GetUserIDs())) {
			header("Location: ".getCurPageURLWO()."/adminpollobject.php");
			ob_end_flush();
			exit;
		} else {
			header("Location: ".getCurPageURLWO()."/personal.php");
			ob_end_flush();
			exit;
		}
	}
}

if(!(is_readable(realpath(dirname(__FILE__)).'/classes/tree.php'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/classes/tree.php');
} else {
	include_once(realpath(dirname(__FILE__)).'/classes/tree.php');
}


if (isset($_REQUEST['clearlog']) && $_REQUEST['clearlog'] == 1){
	unlink($logfile);
}

if (isset($_REQUEST['scrolllog'])){
	$_SESSION['scrolllog'] = $_REQUEST['scrolllog'] ;
	header("Location: ".getCurPageURLWO()."/adminconsole.php");
	ob_end_flush();
	exit;
}

$_SESSION['adminconsoletoken'] = createGuid(false);
$sstoken = $_SESSION['adminconsoletoken'];
$usr_arr = GetUserIDs();
setCookieAdminLastPage('adminconsole');
?>
<!doctype html>
<html>
<head>
	<title><?php echo renderTitle();?></title>
	<? 
	renderCommonMeta(renderTitle()); 
	renderCommonCSS(); 
	?>
</head>
<body>
	<?php renderModalHourGlassDiv();?>
	<div id="container">
	<?php renderLoginBlock(); ?>
	<div id="main" role="main" class="ui-layout-center">
		<?php renderMainMenu(strtolower(pathinfo($_SERVER['PHP_SELF'], PATHINFO_FILENAME)), FALSE); ?>
			<div id="box-tabs">
				<ul class="list-tabs">
					<li><a href="admingeneral.php"><?php getResource("button.admin.general");?></a></li>
					<li><a href="admin.php"><?php getResource("button.admin.statistic");?></a></li>
					<li class="active"><a href="#"><?php getResource("button.admin.console");?></a></li>
					<li><a href="adminpollobject.php"><?php getResource("button.admin.polls");?></a></li>					
				</ul>
			</div>
		</section>
		<div id="content" class="ui-layout-center">
			<section id="box-input" class="box-front-bottom front-menu clearfix">
<div id="servicedatashort" name ="servicedatashort" style="width:100%"></div>
<div id="servicedata" name ="servicedata" style="width:100%"></div>
<div id="loadingbox" name="loadingbox" style="font-weight: bolder;"></div>
<br/><br/>
<textarea id="log" name="log" rows="10" style="width:99%;" readonly="readonly">
<?php
	if (is_readable($logfile)) {
		echo file_get_contents($logfile);
	}
?>
</textarea>
	<div align="right" style="margin-top: 10px;">
		<form id="refresh" action="" method="post" style="display: inline;">
			<input type="hidden" id="scrolllog" name="scrolllog" value="0"/>
			<span><button class="btn-top btn-top-text" title="<?php getResource("button.refresh");?>"><span><?php getResource("button.refresh");?></span></button></span>
		</form>
		<form id="clearlog" action="" method="post" style="display: inline;">
			<input type="hidden" id="clearlog" name="clearlog" value="1"/>
			<span style="margin-left: 11px;"><button class="btn-top btn-top-text" title="<?php getResource("button.log.clear");?>"><span><?php getResource("button.log.clear");?></span></button></span>
		</form>
	</div>
</section>
</div>

</body>
<script src="js/script.js"></script>
<script src="js/libs/jquery.cookie.js"></script>
<script>
    $(function(){
    <?php if (isset($_SESSION['scrolllog'])) { ?>
    	$("#log").animate({scrollTop: <?php echo $_SESSION['scrolllog']; unset($_SESSION['scrolllog']); ?> });

    <?php } ELSE { ?>
    	var textarea = document.getElementById('log');
		textarea.scrollTop = textarea.scrollHeight;
	<?php } ?>

		var sstoken = '<?php echo $sstoken;?>';
		var loadingtext = '<?php getResource("title.loading");?>';
		var i = 0;
		$("#servicedatashort").hide(); // 64433
		$("#servicedata").hide();

		setInterval(function() {
			i = ++i % 8;
			$("#loadingbox").html(loadingtext + " " + Array(i+1).join("."));
		}, 500);
	    $.ajax({
	        type: "POST",
	        url: ("service/adminconsoledata.php?token=" + sstoken),
	        data: "url="+encodeURIComponent(window.location.href),
	        success: function(arg){
	    		var msg = arg;
		     	if ( msg.toString().length > 0 ) {
		     		$("#servicedata").append(msg);
					$("#servicedatashort").show(); // 64433
					$("#servicedata").show();
				}
	        },
	        complete:function(arg){
	        	$("#loadingbox").remove();
	        }
	    });


	    $.ajax({
	        type: "POST",
	        url: ("service/adminconsoledatashort.php?token=" + sstoken),
	        data: "url="+encodeURIComponent(window.location.href),
	        success: function(arg){
	    		var msg = arg;
		     	if ( msg.toString().length > 0 ) {
					$("#servicedatashort").append(msg);
				}
	        }
	    });

    });

	$("#log").scroll(function(){
		 var scroll = $("#log").scrollTop();
		 $("#scrolllog").val(scroll);
	 });
</script>

<?php
	if(!(is_readable(realpath(dirname(__FILE__)).'/templates/languagesbox.template'))) {
		die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/templates/languagesbox.template');
	} else {
		include_once(realpath(dirname(__FILE__)).'/templates/languagesbox.template');
	}
?>

<?php renderFooterTemplate(); ?>

</html>
<?php 
	session_write_close();
	ob_end_flush(); 
?>
