<?php
ob_start();
if(!(is_readable(realpath(dirname(__FILE__)).'/include/includesroutines.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/includesroutines.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/includesroutines.inc');
}

checkUserAndRedirectToLogin();

if (isset($_COOKIE['mobilemode']) && $_COOKIE['mobilemode'] == 0) {
	header("Location: businessmodel.php?".$_SERVER["QUERY_STRING"]);
	ob_end_flush();
	exit;
}

if(!(is_readable(realpath(dirname(__FILE__)).'/classes/tree.php'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/classes/tree.php');
} else {
	include_once(realpath(dirname(__FILE__)).'/classes/tree.php');
}

$cn = db_connect();
$contlngid = null;
if (getSetting('portal','useRights',0) == 1){
	$contlngid = $_SESSION['user_idlanguagecontent'];
}
$skbranch = db_getMainSKBranch($cn);
$idbranch = db_getMainIDBranch($cn);	

$hideheader = (isset($_COOKIE['hideheader']) ?  $_COOKIE['hideheader'] : 0);

$rguid = null;
$oguid = null;

if (isset($_REQUEST['oguid']) ){
	$oguid = $_REQUEST['oguid'];
}

if (isset($_REQUEST['rguid'])){
	$rguid = $_REQUEST['rguid'];
}

setCookieMobileMode(1);

$objectName = db_getObjectName($cn, $oguid, $contlngid);
$reportName = '';
if ($oguid !== $rguid) {
	db_getReportName($cn, $rguid, $contlngid);
}
$usr_arr = GetUserIDs();
?>
<!doctype html>
<html>
<head>
	<title><?php echo renderTitle();?></title>
	<? 
	renderCommonMeta(renderTitle());
	renderCommonCSS(); 
	?>
	<style type="text/css">
	div.modal{
		position:absolute;
		z-index:99;
		display:none;
		width:300px;
		height:150px;
		padding:10px;
		display: table-cell;
		vertical-align: middle;
		text-align:center;
	}
	</style>
</head>
<body>
	<?php renderModalHourGlassDiv();?>
	<div id="container">
	<?php renderLoginBlock(); ?>
	<div id="main" role="main" class="ui-layout-center">
		<?php renderMainMenu(); ?>
		<section id="box-tree-full">
			<header class="clearfix header-hide-overflow">
				<h1><nobr><?php getResource("field.navigator"); echo ' - '.db_getBranchName($cn,$skbranch,$contlngid);?></nobr></h1>
			</header>


<div id="box-tree-full-int" class="content">
<div id="sidetree">
<div class="treeheader">&nbsp;</div>
<ul id="mixed">

<?php
$tr_arr = array();
if (!($oguid === null)){
	if ( !( db_getUserRightsToObject($cn, GetUserIDs(), $oguid) )) {
		header("Location: ".getCurPageURLWO()."/pagenotfound.php?&url=".getCurPageWithEncodeParams());
		ob_end_flush();
		$oguid = null;
		exit;
	} else {
		$idobj = 0;
 		$idobj = db_getIDObjectByGuid($cn, $oguid);
 		if ( $idobj == 0 ) {
 			echo " НЕТ ПРАВ НА ПРОСМОТР ".$oguid;
 			exit;
 		}

 		$tr_arr = db_getPreparedObjectTreetoUser($cn, $idobj ,GetUserIDs(), $contlngid);
		$roots = db_getRootObjectTreeFromPreparetTree($cn);
		$size = sizeof($tr_arr);
		$tree = new Tree();
		for($i=0; $i<$size; $i++){
			if (in_array($tr_arr[$i]['idobject'], $roots)){
				$tree->addItem($tr_arr[$i]['idobject'], 0, $tr_arr[$i]);
			} else {
				$tree->addItem($tr_arr[$i]['idobject'], $tr_arr[$i]['parent_idobject'], $tr_arr[$i]);
			}
		}
		echo $tree->createHtml(0);
 		unset($tr_arr);
 		unset($roots);
 		unset($tree);
	}
} else {
	$tr_arr = db_getObjectTreetoUser($cn, 0, GetUserIDs(), $contlngid);
	foreach ($tr_arr as $node) {
		echo '<li id="'.$node['idobject'].'" name="'.$node['o_guid'].'" class="hasChildren"><nobr><span><img src="./img/objects/'.$node['o_icon'].'.png" /><a href="businessmodel.php?oguid='.$node['o_guid'].'" title="'.$node['o_name'].'">'.$node['o_name'].'</a></span></nobr>';
		if (($node['o_iright'] - $node['o_ileft']) != 1 ){
			echo '<ul>';
			echo '	<li><span class="placeholder">&nbsp;</span></li>';
			echo '</ul>';
		}
		echo '</li>';
	}
}
?>
</ul>
			</div>
		</section>
	</div>
</div>
<script src="js/libs/jquery.cookie.js"></script>
<script src="js/libs/jquery.layout.js"></script>
<script src="js/libs/jquery.treeview.js"></script>
<script src="js/libs/jquery.treeview.edit.js"></script>
<script src="js/libs/jquery.treeview.async.mobile.js"></script>
<script src="js/libs/jquery.scrollTo.js"></script>
<script src="js/script.js"></script>
<script>
	function clearforumpage(){
		$.get( "<?php echo getCurPageURLWO(); ?>/service/clearforumpage.php", function( ) {});
	}

    // on load form
	$(document).ready(function(){
		clearforumpage();
		initTrees("service/treeStructService.php");
	<?php
		if (!($oguid === null)){
			echo "$('div#box-tree-int').scrollTo('li[name=\"".$oguid."\"]');";
			echo "$('li[name=\"".$oguid."\"]').css('fontWeight', 'bold');";
			echo "$('li[name=\"".$oguid."\"] ul').children().css('font-weight', 'normal');";
		}
	?>
	});

</script>
<?php
	if(!(is_readable(realpath(dirname(__FILE__)).'/templates/languagesbox.template'))) {
		die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/templates/languagesbox.template');
	} else {
		include_once(realpath(dirname(__FILE__)).'/templates/languagesbox.template');
	}
?>
<?php renderFooterTemplate(); ?>
</body>
</html>
<?php
db_disconnect($cn);
unset($tr_arr);
ob_end_flush();
?>