function setSearchObjectTreeEvents() {
    $('#mixed').find('input.searchinobj').change(function () {
        if (!$(this).parent().parent().parent().hasClass('collapsable')) {
            $(this).parent().parent().parent().find('input.searchinobj').prop('checked', this.checked);
        }       
    });
}

function initReportsTree(dataUrl, firstLineHide) {
    if ($("#mixed_searchreports").length) {
        $("#mixed_searchreports").treeview({
            url: dataUrl,
            collapsed: true,
            ajax: {
                type: "post"
            }
        });
        var count = $('#mixed_searchreports > li').size();
        var lifirst = $("ul#mixed_searchreports li:first");
        if (firstLineHide == null || firstLineHide) {
            if (count > 1) {
                lifirst.attr("style", "background: url(css/images/treeview-default-line-empty.gif) 0 0px no-repeat;");
            } else if (count == 1) {
                if (lifirst.hasClass("lastExpandable")) {
                    lifirst.attr("style", "background: none;").removeClass('lastExpandable').addClass('expandable');
                    lifirst.find("div:first").removeClass('expandable-hitarea').removeClass('lastExpandable-hitarea').addClass('rootExpandable-hitarea');
                } else {
                    lifirst.attr("style", "background: none;").removeClass('lastCollapsable').addClass('collapsable');
                    lifirst.find("div:first").removeClass('collapsable-hitarea').removeClass('lastCollapsable-hitarea').addClass('rootCollapsable-hitarea');
                }
            }
        }
    }
}

$(document).ready(function ()
{
	$( "#box-search-form-extended-title" ).click(function() {
		$("#btn-toggle-title").toggleClass( "closed" );
		$( "#box-search-form-extended-form-container" ).toggle();
		var u  = new Url;
		
		if ($("#box-search-form-extended-form-container").is(':visible')) {
			$('input[name="hidepanel"]').val("0");
            u.query.hidepanel = 0;
            if ($("#box-paginator").length) {
                var pagenatorhtml = $("#box-paginator").html();
                pagenatorhtml = pagenatorhtml.replace(new RegExp("hidepanel=1",'g'),"hidepanel=0");
                $("#box-paginator").html(pagenatorhtml);
                delete pagenatorhtml;
            }
		} else {
			$('input[name="hidepanel"]').val("1");
            u.query.hidepanel = 1;
            if ($("#box-paginator").length) {
                var pagenatorhtml = $("#box-paginator").html();
                pagenatorhtml = pagenatorhtml.replace(new RegExp("hidepanel=0",'g'),"hidepanel=1");
                $("#box-paginator").html(pagenatorhtml);
                delete pagenatorhtml;
            }
		}
		if ( supportHistoryApi()) {
			history.replaceState(null,'',u);
		}
	});
});