<?php
if(!(is_readable(realpath(dirname(__FILE__)).'/log.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/log.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/log.inc');
}


class SSLMail {
    public function __construct($smtp_username, $smtp_password, $smtp_host, $smtp_from, $smtp_port = 25, $smtp_charset = "utf-8") {
        $this->smtp_username = $smtp_username;
        $this->smtp_password = $smtp_password;
        $this->smtp_host = $smtp_host;
        $this->smtp_from = $smtp_from;
        $this->smtp_port = $smtp_port;
        $this->smtp_charset = $smtp_charset;
    }

    function send($mailTo, $subject, $message, $headers) {
        $contentMail = "Date: ".date("D, d M Y H:i:s O") . "\r\n";
        $contentMail .= 'Subject: =?' . $this->smtp_charset . '?B?'  . base64_encode($subject) . "=?=\r\n";
        $contentMail .= $headers . "\r\n";
        $contentMail .= $message . "\r\n";

        try {
            if(!$socket = @fsockopen($this->smtp_host, $this->smtp_port, $errorNumber, $errorDescription, 30)){
                throw new Exception($errorNumber.".".$errorDescription);
            }
            if (!$this->_parseServer($socket, "220", __LINE__)){
                throw new Exception('Connection error');
            }

			$server_name = $_SERVER["SERVER_NAME"];
            fputs($socket, "HELO $server_name\r\n");
            if (!$this->_parseServer($socket, "250", __LINE__)) {
                fclose($socket);
                throw new Exception('Failed to send HELO');
            }

            fputs($socket, "AUTH LOGIN\r\n");
            if (!$this->_parseServer($socket, "334", __LINE__)) {
                fclose($socket);
                throw new Exception('Failed to send AUTH LOGIN');
            }

            fputs($socket, base64_encode($this->smtp_username) . "\r\n");
            if (!$this->_parseServer($socket, "334", __LINE__)) {
                fclose($socket);
                throw new Exception('Authorization login not accepted by the server!');
            }

            fputs($socket, base64_encode($this->smtp_password) . "\r\n");
            if (!$this->_parseServer($socket, "235", __LINE__)) {
                fclose($socket);
                throw new Exception('Password is invalid, not accepted by the server! Authorization Error!');
            }

            fputs($socket, "MAIL FROM: <".$this->smtp_username.">\r\n");
            if (!$this->_parseServer($socket, "250", __LINE__)) {
                fclose($socket);
                throw new Exception('Failed to send MAIL FROM');
            }

			$mailTo = ltrim($mailTo, '<');
			$mailTo = rtrim($mailTo, '>');
            fputs($socket, "RCPT TO: <" . $mailTo . ">\r\n");
            if (!$this->_parseServer($socket, "250", __LINE__)) {
                fclose($socket);
                 logmailevent('Email not set for user '.$username);
                throw new Exception('Failed to send RCPT TO');
            }

            fputs($socket, "DATA\r\n");
            if (!$this->_parseServer($socket, "354", __LINE__)) {
                fclose($socket);
                throw new Exception('Failed to send DATA');
            }

            fputs($socket, $contentMail."\r\n.\r\n");
            if (!$this->_parseServer($socket, "250", __LINE__)) {
                fclose($socket);
                throw new Exception("Email not sent!");
            }

            fputs($socket, "QUIT\r\n");
            fclose($socket);
        } catch (Exception $e) {
         	logmailevent($e->getMessage());
            return false;
        }
        return true;
    }

    private function _parseServer($socket, $response, $line) {
	      $server_response = '';
        while (@substr($server_response, 3, 1) != ' ') {
            if (!($server_response = fgets($socket, 256))) {
                logmailevent('mail.inc Errors sending email! '.$response.' '.$line.'');
                return false;
            }
        }
        if (!(substr($server_response, 0, 3) == $response)) {
			logmailevent('mail.inc Errors sending email! '.$server_response.' '.$line.' ');
            return false;
        }
        return true;
    }
}

function smtpmail($mailTo, $subject, $message, $username = '[not transmitted]') {
	$mail = new SSLMail(getSetting('smtp','username',''), getSetting('smtp','password',''), getSetting('smtp','host',''), getSetting('smtp','from',''), getSetting('smtp','port',''), 'utf-8');
	$headers= "MIME-Version: 1.0\r\n";
	$headers .= "Content-type: text/html; charset=utf-8\r\n";
	$headers .= "From: ".getSetting('smtp','from','')."\r\n";
	return $mail->send($mailTo, $subject, $message, $headers);
}
?>